import { http } from '@inside-library/helpers/Http'

const fetchNewsListing = async () => {
  try {
    const { data } = await http.get('content/news', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'chapo',
        'slug',
        'content_type',
        'is_featured',
        { news_categories: ['uuid', 'title'] },
        { reactions: ['count', { users: ['uuid'] }] },
        { comments: ['count'] }
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()',
        limit: 4,
        offset: 4
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchExternalNewsListing = async () => {
  try {
    const data = await http.get('rss?flux=https://fibre.syane.fr/feed', {
      fields: ['title', 'link', 'pubDate'],
      filters: {
        limit: 3
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchNewsListing, fetchExternalNewsListing }
