import { http } from '@inside-library/helpers/Http'

import { isAgentUser } from '../../inside-customs/helpers/index'

import get from 'lodash/get'

export default {
  users: {
    add: () => ({ name: 'AdminUsersPage' }),
    delete: () => ({ name: 'AdminUsersPage' }),
    globalSearch: ({ data, vm }) => ({
      action: () => {
        if (isAgentUser()) {
          vm.triggerModal(
            'user-agent',
            'fetch',
            {
              item: data,
              contentType: data.contentType
            },
            { layout: 'right', size: 'm', transition: 'fadeInLeft' }
          )
        } else {
          vm.triggerModal(
            'user-delegate',
            'fetch',
            {
              item: data,
              contentType: data.contentType
            },
            { layout: 'right', size: 'm', transition: 'fadeInLeft' }
          )
        }
      }
    })
  },
  jobOffers: {
    add: () => ({ name: 'JobsListingPage' }),
    delete: () => ({ name: 'JobsListingPage' }),
    globalSearch: ({ data, vm }) => ({
      action: () => {
        vm.triggerModal(
          'offers',
          'fetch',
          {
            item: data,
            contentType: data.contentType
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
      }
    })
  },
  typeSectors: {
    add: () => ({ name: 'JobsListingPage' }),
    delete: () => ({ name: 'JobsListingPage' }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  eventsParticipants: {
    fields: [{ events: ['slug'] }],
    add: ({ data }) => ({
      name: 'EventSubscription',
      params: { slug: data.events.data[0].slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'EventPage',
      params: { slug: data.events.data[0].slug[0] }
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  requestForms: {
    add: ({ data }) => ({
      name: 'RequestsPage',
      params: { slug: data.slug[0] }
    })
  },
  delegatesSpace: {
    add: ({ data }) => ({
      name: 'DelegatesSpacePage',
      params: { slug: data.slug[0] }
    })
  },
  hrSpace: {
    add: ({ data }) => ({
      name: 'JobSpacePage',
      params: { slug: data.slug[0] }
    })
  },
  groupingPages: {
    fields: ['uuid', { hr_space: ['slug'] }],
    add: ({ data }) => {
      return {
        name: 'JobSpacePage',
        params: {
          slug: data.hr_space.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/grouping_pages', {
          fields: [
            {
              hr_space: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        const slug =
          get(data, [0, 'hr_space', 'slug', 0]) ||
          get(data, [0, 'hr_space', 'data', 0, 'slug', 0])

        return {
          name: 'JobSpacePage',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  },
  jobPages: {
    add: ({ data }) => ({
      name: 'JobPage',
      params: { slug: data.slug[0] }
    }),
    delete: async ({ uuid }) => {
      try {
        let { data } = await http.get('content/job_pages', {
          fields: [
            {
              grouping_pages: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })
        let uuidGroupingSpace = data[0].grouping_pages.uuid

        data = await http.get('content/grouping_pages', {
          fields: [
            {
              job_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidGroupingSpace }
        })

        const slug =
          get(data, ['data', 0, 'hr_space', 'slug', 0]) ||
          get(data, ['data', 0, 'hr_space', 'data', 0, 'slug', 0])

        return {
          name: 'JobSpacePage',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  publicServices: {
    add: () => ({ name: 'ServicesDirectoryPage' }),
    delete: () => ({ name: 'ServicesDirectoryPage' }),
    globalSearch: ({ data, vm }) => ({
      action: () => {
        vm.triggerModal(
          'user-public-services',
          'fetch',
          {
            item: data,
            contentType: data.contentType
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
      }
    })
  }
}
