import { isSuperAdmin, isAdmin } from '@inside-library/helpers/Rights'

import { isAgentUser } from '../helpers/index'

export const agentsAccessGuard = async ({ store, next }) => {
  const isAgent = await isAgentUser()

  if (!isAgent && !isSuperAdmin() && !isAdmin()) {
    this.$router.push({
      name: 'ErrorPage',
      params: {
        code: '403'
      }
    })
  }

  next()
}
