import imageButtonLink from '@inside-library/assets/img/custom-page/imageButtonLink.png'
import imageHrCounter from '../../assets/img/custom-page/imageHrCounter.png'
import imageCtaBlocksListing1Column from '@inside-library/assets/img/custom-page/imageCtaBlocksListing1Column.png'
import imageHeroRight from '../../assets/img/custom-page/imageHeroRight.png'

export const availableComponents = (t, app) => [
  {
    component: 'HomeButtonLink',
    label: t('customs.CUSTOM_PAGE.homeButtonLink.label'),
    image: imageButtonLink,
    options: {
      skipLoading: true,
      link: {
        type: 'link',
        value: '',
        title: t(
          'layouts.CUSTOM_PAGE.EDIT_COMPONENT_SIDEBAR.commonOptions.componentLink.title'
        ),
        help: t(
          'layouts.CUSTOM_PAGE.EDIT_COMPONENT_SIDEBAR.commonOptions.componentLink.help'
        ),
        rules: ['required']
      },
      linkLabel: {
        type: 'text',
        value: '',
        title: t(
          'layouts.CUSTOM_PAGE.EDIT_COMPONENT_SIDEBAR.commonOptions.componentLinkLabel.title'
        ),
        rules: ['required']
      },
      target: {
        type: 'onoff',
        value: false,
        label: t('commons.CUSTOM_PAGE.buttonLink.options.target.label'),
        rules: ['required']
      },
      icon: {
        type: 'icon',
        value: 'arrow-link',
        title: t('commons.CUSTOM_PAGE.buttonLink.options.icon.title')
      },
      backgroundColor: {
        type: 'hexacolor',
        value: app.config.globalProperties.$_theme('colorPrimary'),
        title: t(
          'layouts.CUSTOM_PAGE.EDIT_COMPONENT_SIDEBAR.commonOptions.componentBackgroundColor.title'
        )
      }
    },
    layouts: []
  },
  {
    component: 'HomeHrCounter',
    label: t('customs.CUSTOM_PAGE.homeHrCounter.label'),
    image: imageHrCounter,
    options: {},
    layouts: []
  },
  {
    component: 'HomeRequests',
    label: t('customs.CUSTOM_PAGE.homeRequests.label'),
    image: imageCtaBlocksListing1Column,
    options: {},
    layouts: []
  },
  {
    component: 'HomeHeroRight',
    label: t('customs.CUSTOM_PAGE.homeHeroRight.label'),
    image: imageHeroRight,
    options: {},
    layouts: [
      { layout: 1 },
      { layout: 2 },
      { layout: 5, requiredRatio: 3 },
      { layout: 6, requiredRatio: 3 },
      { layout: 7, requiredRatio: 2 },
      { layout: 8, requiredRatio: 2 },
      { layout: 9, requiredRatio: 2 },
      { layout: 10, requiredRatio: 2 }
    ]
  }
]

export const componentImport = {
  HomeButtonLink: () => import('../../components/homepage/HomeButtonLink'),
  HomeHrCounter: () => import('../../components/homepage/HomeHrCounter'),
  HomeRequests: () => import('../../components/homepage/HomeRequests'),
  HomeHeroRight: () => import('../../components/homepage/HomeHeroRight')
}
