import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import OffersModal from '../components/modals/OffersModal'
import WelcomeModal from '../components/modals/new-comer/WelcomeModal'
import UserAgentModal from '../components/modals/users/UserAgentModal'
import UserDelegateModal from '../components/modals/users/UserDelegateModal'
import UserCollectivitiesModal from '../components/modals/users/UserCollectivitiesModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('offers-modal', OffersModal)
    app.component('welcome-modal', WelcomeModal)
    app.component('user-agent-modal', UserAgentModal)
    app.component('user-delegate-modal', UserDelegateModal)
    app.component('user-collectivities-modal', UserCollectivitiesModal)
  })
}
