<?php

namespace Inside\SYAN\Services\Horoquartz;

use Exception;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class HoroquartzService
{
    private ?string $matricule = null;

    public function __construct(?string $matricule = null)
    {
        try {
            new HoroquartzToken();

            $this->matricule = $matricule ?? Auth::user()?->matricule;
        } catch (Exception $exception) {
            Log::error("[horoquartz] {$exception->getMessage()}");
        }
    }

    public function getVacationBalance(): float
    {
        $envelope = HoroquartzRequest::envelopeSalesForce(
            service: 'getEmployeeCounters',
            request: 'waxRequest',
            params: [
                'codeFct' => 'WB1',
                'matricule' => $this->matricule,
            ]
        );

        $request = HoroquartzRequest::post(config('horoquartz.url.services'), $envelope);
        $result = collect();

        if ($request->successful()) {
            $result = $request->response()->meters(
                namespace: 'ns4',
                key: 'counter',
                name: 'counterName',
                value: 'counterValue'
            );
        }

        return $result->get('CPT_01_01', 0) + $result->get('CPT_01_02', 0);
    }

    public function getCumulatedDayBefore(): ?float
    {
        $envelope = HoroquartzRequest::envelopeSalesForce(
            service: 'getEmployeeCounters',
            request: 'waxRequest',
            params: [
                'codeFct' => 'WA10',
                'matricule' => $this->matricule,
            ]
        );

        $request = HoroquartzRequest::post(config('horoquartz.url.services'), $envelope);
        $result = collect();

        if ($request->successful()) {
            $result = $request->response()->meters(
                namespace: 'ns4',
                key: 'counter',
                name: 'counterName',
                value: 'counterValue'
            );
        }

        return $result->get('CPT_02_11');
    }

    public function getDailyBadging(): array
    {
        $envelope = HoroquartzRequest::envelopeSalesForce(
            service: 'clocksOfTheDay',
            request: 'wclocksRequest',
            params: [
                'date' => Carbon::now()->timezone('Europe/Paris')->format('Y-m-d'),
                'matricule' => $this->matricule,
            ]
        );

        $request = HoroquartzRequest::post(config('horoquartz.url.services'), $envelope);
        $result = collect();

        if ($request->successful()) {
            $result = collect($request->response()
                ->meters(['ns2', 'ns10'], 'clock', 'Hour', 'Direction')
                ->map(fn ($direction, $hour) => [
                    'hour' => Carbon::createFromFormat('H.i', $hour, 'Europe/Paris'),
                    'direction' => (string) $direction,
                ])
                ->last());
        }

        return [
            'hour' => $result->get('hour') instanceof Carbon ? $result->get('hour')->timezone('UTC')->timestamp : '',
            'direction' => $result->get('direction', ''),
        ];
    }

    public function badging(): void
    {
        $envelope = HoroquartzRequest::envelopeSalesForce(
            service: 'createClock',
            request: 'wclocksRequest',
            params: ['matricule' => $this->matricule]
        );

        HoroquartzRequest::post(config('horoquartz.url.services'), $envelope);
    }
}
