<?php

namespace Inside\SYAN\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;
use Inside\SYAN\Mail\FormSendEmail;

class FormSend implements ShouldQueue
{
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * @var mixed
     */
    protected $user;

    /**
     * @var string
     */
    protected $content;

    /**
     * @var mixed
     */
    protected $requestThemes;

    /**
     * @var mixed
     */
    protected $requestTypes;

    /**
     * @var mixed
     */
    private $requestForm;

    /**
     * @param mixed $user
     * @param mixed $requestThemes
     * @param mixed $requestForm
     * @param string $requestContent
     * @param mixed $requestTypes
     */
    public function __construct($user, $requestThemes, $requestForm, string $requestContent, $requestTypes)
    {
        $this->user = $user;
        $this->content = $requestContent;
        $this->requestForm = $requestForm;
        $this->requestThemes = $requestThemes;
        $this->requestTypes = $requestTypes;
    }

    public function handle(): void
    {
        Mail::to($this->requestTypes->mailto)->send(
            new FormSendEmail(
                $this->user,
                $this->requestThemes,
                $this->requestForm,
                $this->content,
                $this->requestTypes
            )
        );
    }
}
