<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@100;300;400;500;700&display=swap" rel="stylesheet">
    <title>@yield('title')</title>
    <style>
        * {
            font-family: Roboto, sans-serif;
        }

        body {
            margin: 0;
            color: #333333;
        }

        a {
            text-decoration: none;
            color: #333333;
        }

        .entete {
            display: flex;
            align-items: center;
        }

        .logo-principal {
            display: flex;
            justify-content: center;
            width: auto;
            margin: 15px 0;
        }

        .logo-principal img {
            width: 220px;
            height: 50px;
        }

        .banniere {
            display: flex;
            justify-content: center;
            align-items: center;
            color: white;

            margin-bottom: 50px;
            text-align: center;
            width: 100%;
            height: 200px;
            background-image: url("/vendor/maecia/syan-back/resources/assets/img/error/banniere.jpg");
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center;
        }

        .banniere p {
            font-size: 15px;
        }

        h1 {
            line-height: 1.2;
            font-weight: 700;
        }

        .container {
            margin: 0 auto;
            display: grid;
            justify-content: center;
            align-items: center;
            grid-template-columns: repeat(1, 100%);
            gap: 48px;
            position: relative;
            width: 80vw;
            margin-bottom: 100px;
        }

        .droite {
            width: 100%;
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
            gap: 16px;
        }

        .item {
            display: flex;
            box-shadow: 0 0 6px 1px rgba(0, 0, 0, 0.12);
            transition: all 0.2s ease;
            padding: 16px;
            background: #fff;
            cursor: pointer;
            box-sizing: border-box;
        }

        .item a {
            position: relative;
            display: flex;
            -webkit-box-align: center;
            align-items: center;
            transition: all 0.2s ease;
        }

        .item p {
            word-break: break-word;
        }

        .logo {
            width: 64px;
            height: 64px;
            margin-right: 16px;
            -ms-flex-negative: 0;
            flex-shrink: 0;
        }

        .logo img {
            object-fit: contain;
            width: 100%;
            height: 100%;
        }
    </style>
</head>
<body>
<div class="logo-principal">
    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Logo_Syan.png"/>
</div>
<div class="entete">
    <div class="banniere">
        <div>
            <h1> Intranet en maintenance </h1>
            <p>
                L'intranet "Syane et vous" est en maintenance.
                </br>
                L'outil est momentanément indisponible. Nous mettons tout en oeuvre pour rétablir l'accès le plus
                rapidement possible.
                </br>
                En attendant retrouvez vos outils ci-dessous.
            </p>
        </div>
    </div>

</div>
<div class="container">
    <div class="droite">
        <div class="item">
            <a href="https://teams.microsoft.com/_#/conversations/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Teams.jpg"></img>
                </div>
                <p> Teams - visio et tchat de référence</p>
            </a>
        </div>

        <div class="item">
            <a href="https://visio.syane.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Jitsi.jpg"></img>
                </div>
                <p> Jitsi</p>
            </a>
        </div>

        <div class="item">
            <a href="https://primetime.bluejeans.com/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Bluejeans.jpg"></img>
                </div>
                <p> BlueJeans - La visio institutionnelle</p>
            </a>
        </div>

        <div class="item">
            <a href="http://onis.syane.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Element.jpg"></img>
                </div>
                <p> Element</p>
            </a>
        </div>

        <div class="item">
            <a href="https://fibre.syane.fr/eligibilite-de-mon-logement/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/reseau-fibre.webp"></img>
                </div>
                <p> Réseau fibre optique </p>
            </a>
        </div>

        <div class="item">
            <a href="hhttps://sig.syane.fr/adws/app/9651bf00-d813-11eb-83a5-51b77e42787c/index.html?dummy=1638430660259"
               target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/georef_reseaux.jpg"></img>
                </div>
                <p> Géoréférencement des réseaux EP</p>
            </a>
        </div>

        <div class="droite">
            <div class="item">
                <a href="https://www.edenred.fr/" target="_blank">
                    <div class="logo">
                        <img src="/vendor/maecia/syan-back/resources/assets/img/error/Eden-Red.jpg"></img>
                    </div>
                    <p> Eden Red</p>
                </a>
            </div>
        </div>

        <div class="item">
            <a href="https://cloud.syane.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/partage-fichier.png"></img>
                </div>
                <p> Partage de fichiers</p>
            </a>
        </div>

        <div class="item">
            <a href="http://www.islonline.net/start/ISLLightClient?custom=syane-fr" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Teleassistance-Informatique.png"></img>
                </div>
                <p> Téléassistance informatique</p>
            </a>
        </div>

        <div class="item">
            <a href="https://syane.cloud-horoquartz.fr/ux/login" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Horoquartz.jpg"></img>
                </div>
                <p> Badgeage (Horoquartz)</p>
            </a>
        </div>

        <div class="item">
            <a href="https://parapheur.dfast.fr/parapheur/showTableau.action" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Fast-Parapheur-jpg.webp"></img>
                </div>
                <p> Fast-Parapheur</p>
            </a>
        </div>

        <div class="item">
            <a href="https://outlook.office365.com/mail/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/messagerie.png"></img>
                </div>
                <p> Messagerie</p>
            </a>
        </div>

        <div class="item">
            <a href="https://bl.gf.berger-levrault.com/eGfP_SYANE/Login.html" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/eSedit Compta.png"></img>
                </div>
                <p> eSedit Compta</p>
            </a>
        </div>

        <div class="item">
            <a href="https://syane-fr-gir.klervi.net/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Reservation-Vehicule.png"></img>
                </div>
                <p> Réservation Véhicule</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.youtube.com/channel/UCkKG1oGFCqJP6Rw4PGnPFyw" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/youtube.png"></img>
                </div>
                <p> Syan - Youtube</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.linkedin.com/company/77220527" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/linkedin.png"></img>
                </div>
                <p> Syan'EnR - Linkedins </p>
            </a>
        </div>

        <div class="item">
            <a href="https://twitter.com/syane74?lang=fr" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/twitter.png"></img>
                </div>
                <p> Syane - Twitter</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.facebook.com/Reseau.Eborn/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/facebook.png"></img>
                </div>
                <p> eborn - Facebook</p>
            </a>
        </div>

        <div class="item">
            <a href="https://syan.dev.intranet-inside.com/login" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/linkedin.png"></img>
                </div>
                <p> Syan'Chaleur - Linkedin</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.linkedin.com/company/syane-energies-numerique/?originalSubdomain=fr" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/linkedin.png"></img>
                </div>
                <p> Syane - Linkedin</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.linkedin.com/company/territoire-energie-auvergne-rhone-alpes/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/linkedin.png"></img>
                </div>
                <p> TEARA - Linkedin</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.linkedin.com/company/fnccr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/linkedin.png"></img>
                </div>
                <p> FNCCR - Linkedin</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.facebook.com/SYANE74/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/facebook.png"></img>
                </div>
                <p> Syane - Facebook </p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.syane.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/syan-site.png"></img>
                </div>
                <p> www.syane.fr</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.fnccr.asso.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/FNCCR-jpg.webp"></img>
                </div>
                <p> Fnccr</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.eborn.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/eborn.png"></img>
                </div>
                <p> Eborn</p>
            </a>
        </div>

        <div class="item">
            <a href="https://syanchaleur.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Syanchaleur.png"></img>
                </div>
                <p> Syan chaleur</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.syanenr.com/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/syanenr-png.webp"></img>
                </div>
                <p> Syan EnR</p>
            </a>
        </div>

        <div class="item">
            <a href="https://fibre.syane.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Syane-fibre-png.webp"></img>
                </div>
                <p> Syan Fibre</p>
            </a>
        </div>

        <div class="item">
            <a href="https://teara.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/teara.webp"></img>
                </div>
                <p> Teara</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.ledauphine.com/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Dauphine-Libere.jpg"></img>
                </div>
                <p> Dauphiné Libéré</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.lagazettedescommunes.com/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/gazette-jpg.webp"></img>
                </div>
                <p> La gazette des communes</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.lemessager.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Le-messager-jpg.webp"></img>
                </div>
                <p> Le messager</p>
            </a>
        </div>

        <div class="item">
            <a href="https://bl.rh.berger-levrault.com/eGrhP_SYANE/GRH.html" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/e.Sedit-RH-jpg.webp"></img>
                </div>
                <p> eSedit RH</p>
            </a>
        </div>

        <div class="item">
            <a href="http://gestoa-test.syane.fr/cgi-bin/acces.exe" target="_blank">
                <div class="logo">
                    <img
                        src="/vendor/maecia/syan-back/resources/assets/img/error/Teleassistance-Informatique.png"></img>
                </div>
                <p> GMAO EP - Geo</p>
            </a>
        </div>

        <div class="item">
            <a href="https://deepki-ready.deepki.com/login?next=%2F" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/DEEPKI-jpg.webp"></img>
                </div>
                <p> DEEPKI</p>
            </a>
        </div>

        <div class="item">
            <a href="http://espace-adherents.syane.fr/WebVilleServer/resources/jsp/login/login.jsp" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/espace-adherent.jpg"></img>
                </div>
                <p> GMAO Ep - Webville</p>
            </a>
        </div>

        <div class="item">
            <a href="https://syane.govalid.io/#/sign-in" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/robot-controle.png"></img>
                </div>
                <p> Robot de contrôle Mappia</p>
            </a>
        </div>

        <div class="item">
            <a href="https://sig.syane.fr/aws/app/53e3fcfc-201e-11eb-98b5-274f126a9061/index.html?dummy=1657002851028"
               target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/symaginer.png"></img>
                </div>
                <p> Symaginer</p>
            </a>
        </div>

        <div class="item">
            <a href="https://glpi.syane.fr/front/central.php" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/GLPI-jpg.webp"></img>
                </div>
                <p> GLPI</p>
            </a>
        </div>

        <div class="item">
            <a href="https://login.wrike.com/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/wrike-png.webp"></img>
                </div>
                <p> Wrike</p>
            </a>
        </div>

        <div class="item">
            <a href="https://sig.syane.fr/adws/app/d8711e21-a081-11ec-b7cf-bd84c29353b9/index.html?dummy=1649251794480"
               target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/borne-syane-jpg.webp"></img>
                </div>
                <p> IRVE - Etudes</p>
            </a>
        </div>

        <div class="item">
            <a href="https://www.marches-publics.info/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/logoAWS.png"></img>
                </div>
                <p> AWS - Marchés publics </p>
            </a>
        </div>

        <div class="item">
            <a href="https://bl.gf.berger-levrault.com/eGfP_SYANE/GF.html" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/e.Sedit-RH-jpg.webp"></img>
                </div>
                <p> e.Sedit GF</p>
            </a>
        </div>

        <div class="item">
            <a href="https://gost.syane.fr/" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/travaux-jpg.webp"></img>
                </div>
                <p> Gost</p>
            </a>
        </div>

        <div class="item">
            <a href="https://cells.syane.fr/login" target="_blank">
                <div class="logo">
                    <img src="/vendor/maecia/syan-back/resources/assets/img/error/Cloud-Syane-jpg.webp"></img>
                </div>
                <p> Cloud RIP</p>
            </a>
        </div>
    </div>
</div>
</body>
</html>
