<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => '',
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/syan-back/resources/assets/img/newsletter/banner.png',
        'backgroundColor' => '#fff',
        'bannerWidth' => 700,
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_intro',
        'textColor' => '#2C3E50',
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'sectionType' => 'news',
            'types' => ['news'],
            'fieldLabel' => [
                'news' => [
                    'fr' => 'Actualités à la une',
                ],
            ],
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#D9232B',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#D9232B',
                'sectionLinkStrKey' => 'newsletter.news_link',
            ],
        ],
        'hr_news'       => [
            'sectionTitleStrKey' => 'Actualités RH',
            'sectionType' => 'news',
            'types' => ['hr_news'],
            'fields' => ['hr_news' => 'news'],
            'fieldLabel' => [
                'hr_news' => [
                    'fr' => 'Actualités RH',
                ],
            ],
            'showDate' => true,
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#D9232B',
            'categoryFieldName' => 'news_categories',
            'link' => [
                'sectionLinkUrl'  => 'espaces/espace-rh',
                'sectionTextColor' => '#D9232B',
                'sectionLinkStrKey' => 'Voir toutes les actualités RH',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'Agenda - Dates à retenir',
            'types' => ['events'],
            'fieldLabel' => [
                'events' => [
                    'fr' => 'Événements',
                ],
            ],
            'sorts' => ['date:desc'],
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#1D91D3',
            'link' => [
                'sectionLinkUrl'   => 'evenements',
                'sectionTextColor' => '#D9232B',
                'sectionLinkStrKey' => 'Voir toutes les dates',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'fieldLabel' => [
                'documents' => [
                    'fr' => 'Documents',
                ],
            ],
            'sorts' => ['published_at:desc'],
            'imageStyle' => 'medium',
            'leftLineColor' => '#003A7B',
            'link'            => [
                'sectionLinkStrKey' => 'Voir toutes les ressources',
                'sectionLinkUrl' => 'mediatheque',
                'sectionTextColor' => '#D9232B',
            ],
        ],
        'job_offers'     => [
            'sectionTitleStrKey' => 'Dernières offres d\'emploi',
            'types' => ['job_offers'],
            'fieldLabel' => [
                'events' => [
                    'fr' => 'Offres d\'emploi',
                ],
            ],
            'categoryFieldName' => 'type_sectors',
            'leftLineColor' => '#003A7B',
            'link' => [
                'sectionLinkUrl'   => 'offres-emploi',
                'sectionTextColor' => '#D9232B',
                'sectionLinkStrKey' => 'Voir toutes les offres',
            ],
        ],
        'new_members' => [
            'sectionTitleStrKey' => 'newsletter.new_members_title',
            'introductionLength' => 50,
            'introductionFieldName' => 'function',
            'types'           => ['movements'],
            'fieldLabel' => [
                'movements' => [
                    'fr' => 'Mouvements',
                ],
            ],
            'link' => [
                'sectionLinkUrl'  => 'mouvements',
                'sectionTextColor' => '#D9232B',
                'sectionLinkStrKey' => 'newsletter.see_all_new_members',
            ],
        ],
        'activities' => [
            'sectionTitleStrKey' => 'Syane et vous en chiffres',
            'link'        => null, // Pas de links
            'orientation' => 'horizontal',
            'defaultBackgroundColor' => '#FFFFF',
            'defaultValueColor' => '#2c3f50',
            'items'       => [
                'comments' => [
                    'callback'           => function () {
                        return Inside\Content\Models\Contents\Comments::count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/syan-back/resources/assets/img/newsletter/comments.png',
                    'titleStrKey'        => 'newsletter.comments_statistic',
                ],
                'likes'    => [
                    'callback'           => function () {
                        return Inside\Reaction\Models\Reaction::where('type',
                            'like')->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/syan-back/resources/assets/img/newsletter/likes.png',
                    'titleStrKey'        => 'newsletter.likes_statistic',
                ],
                'users'    => [
                    'callback'           => function () {
                        return Inside\Content\Models\Contents\Users::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/syan-back/resources/assets/img/newsletter/users.png',
                    'titleStrKey'        => 'newsletter.users_statistic',
                ],
                'news'     => [
                    'callback'           => function () {
                        return Inside\Content\Models\Contents\News::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/syan-back/resources/assets/img/newsletter/news.png',
                    'titleStrKey'        => 'newsletter.contents_statistic',
                ],
            ],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#D9232B',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/SYANE74/',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/SYANE74',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/syane-energies-numerique/',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/channel/UCkKG1oGFCqJP6Rw4PGnPFyw',
            ],
        ],
        'secondLineLinks' => [
            'syane' => [
                'url' => 'https://www.syane.fr/',
                'titleStrKey' => 'syane.fr',
                'imageUrl' => false,
            ],
            'fibre' => [
                'url' => 'https://fibre.syane.fr/',
                'titleStrKey' => 'fibre.syane.fr',
                'imageUrl' => false,
            ],
            'chaleur' => [
                'url' => 'https://www.syanchaleur.fr/',
                'titleStrKey' => 'syanchaleur.fr',
                'imageUrl' => false,
            ],
            'enr' => [
                'url' => 'https://www.syanenr.com/',
                'titleStrKey' => 'syanenr.com',
                'imageUrl' => false,
            ],
            'eborn' => [
                'url' => 'http://eborn.fr/',
                'titleStrKey' => 'eborn.fr',
                'imageUrl' => false,
            ],
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#F0F0F0',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning',
    ],
];
