<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddedMissingPermissibleTypes extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateOrCreate(
            type: 'courses_chapters',
            options: [
                'permissible' => true,
                'categorizable' => true,
            ],
        );

        $bridge->contentTypeUpdateOrCreate(
            type: 'courses_lessons',
            options: [
                'permissible' => true,
                'categorizable' => true,
            ],
        );

        $bridge->contentTypeUpdateOrCreate(
            type: 'courses_quizzes',
            options: [
                'permissible' => true,
                'categorizable' => true,
            ],
        );
    }
}
