<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\EventsParticipants;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Reaction\Facades\Reactions;

final class CreateNewDirectoryContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('colleges');
        $this->migrateContent('users');

        $this->getBridge()?->contentTypeUpdate('function_delegate', ['title' => ['fr' => 'Fonction Syane']]);
        $this->getBridge()?->changeFieldTitle('users', 'function_delegate', ['fr' => 'Fonction Syane']);

        $this->getBridge()?->contentTypeUpdate('communes', ['title' => ['fr' => 'Collectivité']]);
        $this->getBridge()?->changeFieldTitle('users', 'communes', ['fr' => 'Collectivité']);
        $this->finishUp();
    }
}
