<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\EventsParticipants;
use Inside\Reaction\Facades\Reactions;

class MigrateOldEventRegistrationsToNewGlobalEndpoints extends Migration
{
    public function up(): void
    {
        EventsParticipants::each(function (EventsParticipants $participant) {
            if ($participant->users->isEmpty() || $participant->events->isEmpty()) {
                return;
            }
            Reactions::create([
                'user_uuid' => $participant->users->first()->uuid,
                'reactionable_uuid' => $participant->events->first()->uuid,
                'reactionable_type' => 'Inside\Content\Models\Contents\Events',
                'type' => 'register',
                'langcode' => $participant->langcode,
            ]);
        });
    }
}
