<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateContentTypeUsers extends Migration
{
    use Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $this->bootUp(__FILE__);
        $this->migrateContent('districts');
        $this->finishUp();

        $bridge->contentTypeDeleteField('users', 'users', 'arrondissement');
        $bridge->contentTypeDeleteField('node', 'public_services', 'arrondissement');

        $bridge->contentTypeCreateOrUpdateField('users', 'districts', [
            'name' => 'districts',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Arrondissement',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['districts'],
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('public_services', 'districts', [
            'name' => 'districts',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Arrondissement',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['districts'],
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
