<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RenameFunctionsContentType extends Migration
{
    use Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'users', 'commissions');
        $bridge->contentTypeDeleteField('node', 'users', 'community');

        $this->bootUp(__FILE__);
        $this->migrateContent('intercommunities');
        $this->migrateContent('communes');
        $this->migrateContent('public_services');
        $this->finishUp();

        $bridge->contentTypeCreateOrUpdateField('users', 'commissions', [
            'name' => 'commissions',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Commissions',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['commissions'],
                'cardinality' => -1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('users', 'communes', [
            'name' => 'communes',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Communes',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['communes'],
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
