<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateFieldJobOffers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'job_offers', 'application_deadline');

        $bridge->contentTypeCreateOrUpdateField('job_offers', 'application_deadline', [
            'name' => 'application_deadline',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Date limite de candidature',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
