<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'public_services',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Service public',
        ],
    ],
    'fields' => [
        [
            'name' => 'communes',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Commune',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['communes'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'intercommunity',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Intercommunalité',
            ],
            'description' => [
                'fr' => 'Choix de la catégorie dans laquelle cet outil doit remonter',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['intercommunities'],
                'cardinality' => 1,
            ],
        ],
    ],
];
