<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'modal',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Modale',
        ],
    ],
    'fields' => [
        [
            'name' => 'class',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Classe',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => ['text', 'file', 'image', 'fetched_contents', 'call_to_action'],
                'cardinality' => -1,
            ],
        ],
    ],
];
