<?php

use Illuminate\Console\Scheduling\Schedule;

return [
    'schedule' => [
        'csv_import_users' => function (Schedule $scheduler) {
            $scheduler->command('inside:user:import csv --disable-not-imported')->dailyAt('2:00')->description('csv');
        },
        'azuread_import_users' => function (Schedule $scheduler) {
            $scheduler->command('inside:user:import azuread --disable-not-imported --disable-old-entries')->daily()->at('4:00')->description('azuread');
        },
        'azuread_second_import_users' => function (Schedule $scheduler) {
            $scheduler->command('inside:user:import azuread --disable-not-imported --disable-old-entries')->daily()->at('13:00');
        },
        'events_first_import' => function (Schedule $scheduler) {
            $scheduler->command('syan:import events -p /home/syan-csv/shared/events.csv')->daily()->at('10:00');
        },
        'events_second_import' => function (Schedule $scheduler) {
            $scheduler->command('syan:import events -p /home/syan-csv/shared/events.csv')->daily()->at('12:00');
        },
        'events_third_import' => function (Schedule $scheduler) {
            $scheduler->command('syan:import events -p /home/syan-csv/shared/events.csv')->daily()->at('16:00');
        },
        'events_fourth_import' => function (Schedule $scheduler) {
            $scheduler->command('syan:import events -p /home/syan-csv/shared/events.csv')->daily()->at('20:00');
        },
        'collectivities_import' => function (Schedule $scheduler) {
            $scheduler->command("syan:import collectivities -p '/home/syan-csv/shared/Annuaire des Collectivités adhérentes.csv' -d ','")->daily()->at('06:00');
        },
    ],
];
