<?php

use Illuminate\Support\Arr;

return [
    'inside_external_api_enabled' => env('INSIDE_EXTERNAL_API_ENABLED', true),
    'inside_external_api_bypass_auth_external' => env('INSIDE_EXTERNAL_API_AUTH_BYPASS', true),
    'inside_external_api_paginate_result' => false,
    'inside_external_api_fields' => [
        'job_offers' => [
            'title',
            'application_deadline',
            'application_email',
            'type_sectors' => ['title'],
            'content',
        ],
    ],
    'inside_external_api_fields_content_remove'=> [
        'section_type',
        'uuid',
        'created_at',
        'updated_at',
        'reactions',
        'file',
        'content',
        'has_section',
        'title',
        'description',
        'published_at',
        'statistics',
        'unique_views',
        'total_views',
    ],
    'inside_external_api_filters' => function ($query, $request) {
        $query->where('status', 1);
    },
    'inside_external_api_transform' => function ($result) {
        return collect($result)->map(function ($data) {
            $data['content'] = collect($data['content'])->map(fn ($content) => Arr::except($content,
                config('external_api.inside_external_api_fields_content_remove'))
            )->filter()->toArray();
            // this is a bug, but should be kept before we call the client, see with Elyes why we need to do that #temporary
            $data['content'] = Arr::last($data['content']);

            return $data;
        })->toArray();
    },
    'custom_types' => [
        'jobs' => 'job_offers',
    ],
];
