<?php

use Carbon\Carbon;
use Illuminate\Support\Str;
use Inside\SYAN\Facades\ImportCsv;

return [
    'events' => [
        'type' => function () {
            return 'node';
        },
        'bundle' => function () {
            return 'events';
        },
        'title' => function ($record) {
            return $record['subject'];
        },
        'date' => function ($record) {
            $date = Carbon::createFromFormat('d/m/Y H:i:s', $record['start'], 'Europe/Paris');

            if (! $date) {
                return null;
            }

            return $date->utc()->toDateTimeString();
        },
        'end_date' => function ($record) {
            $date = Carbon::createFromFormat('d/m/Y H:i:s', $record['end'], 'Europe/Paris');

            if (! $date) {
                return null;
            }

            return $date->utc()->toDateTimeString();
        },
        'display_hours' => function ($record) {
            return Str::lower($record['alldayevent']) !== 'true';
        },
        'place' => function ($record) {
            return Str::ucfirst(trim($record['location']));
        },
        'events_categories' => function ($record) {
            return ImportCsv::getEntityReference($record, 'events_categories', 'categories');
        },
        'external_id' => 'id',
    ],
];
