<?php

use Illuminate\Support\Facades\Route;
use Inside\Content\Http\Controllers\External\Index as ExternalIndex;

Route::group(
    [
        'namespace'  => 'Inside\SYAN\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('popin', 'PopinController@popin');
        $router->post('reaction/popin', 'PopinController@reaction');
        $router->post('mail/assistance', 'FormCustomController@sendMail');
    }
);

Route::group(
    [
        'namespace'  => 'Inside\SYAN\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => ['auth.api'],
    ],
    function ($router) {
        $router->get('horoquartz/balance', 'HoroquartzController@getBalance');
        $router->get('horoquartz/last_badging', 'HoroquartzController@getLastBadging');
        $router->post('horoquartz/badging', 'HoroquartzController@badging');
    }
);

Route::group(
    [
        'prefix' => 'api/v1',
    ],
    function ($router) {
        $router->get('external/{type:'.get_authorized_external_api_content_types().'}', ExternalIndex::class);
    }
);
