<?php

namespace Inside\SYAN\Services\Horoquartz;

use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Psr\Http\Message\ResponseInterface;

class HoroquartzResponse
{
    protected string $content = '';

    public function __construct(?ResponseInterface $response)
    {
        if (! is_null($response)) {
            $this->content = $response->getBody()->getContents();
        }
    }

    private static function find(string $haystack, string $start, string $end): string
    {
        $result = (string) str($haystack)->after($start)->before($end)->trim();

        return ($result !== $haystack) ? $result : '';
    }

    public function searchWithNamespace(string $namespace, string $needle): string
    {
        return self::find($this->content, "<$namespace:$needle>", "</$namespace:$needle>");
    }

    public function searchBetween(string $start, string $end): string
    {
        return self::find($this->content, $start, $end);
    }

    public function contains(string $needle): bool
    {
        return str($this->content)->contains($needle);
    }

    public function meters(string | array $namespace, string $key, string $name, string $value): Collection
    {
        return collect(Arr::wrap($namespace))
            ->flatMap(fn (string $namespace) => str($this->content)
                ->matchAll("/<$namespace:$key>(.*?)<\/$namespace:$key>/")
                ->mapWithKeys(function ($meter) use ($namespace, $name, $value) {
                    $name = self::find($meter, "<$namespace:$name>", "</$namespace:$name>");
                    $value = self::find($meter, "<$namespace:$value>", "</$namespace:$value>");

                    return [$name => (float) $value];
                })
            );
    }
}
