<?php

namespace Inside\SYAN\Providers;

use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\SYAN\Console\HoroquartzStats;
use Inside\SYAN\Console\HoroquartzStatsForMatricule;
use Inside\SYAN\Console\ImportCsvCommand;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ServiceProvider extends BaseServiceProvider
{
    protected array $commands = [
        ImportCsvCommand::class,
        HoroquartzStats::class,
        HoroquartzStatsForMatricule::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/user_references.php', 'user_references');
            $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
            $this->mergeConfigFrom(__DIR__.'/../../config/xlsx.php', 'xlsx');
            $this->mergeConfigFrom(__DIR__.'/../../config/collectivities_import.php', 'collectivities_import');
            $this->mergeConfigFrom(__DIR__.'/../../config/events_import.php', 'events_import');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__.'/../../config/horoquartz.php', 'horoquartz');
            $this->mergeConfigTo(__DIR__.'/../../config/external_api.php', 'external_api');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
