<?php

namespace Inside\SYAN\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Lang;

/**
 * Class FormSendEmail
 */
class FormSendEmail extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * @var mixed
     */
    protected $user;

    /**
     * @var string
     */
    protected $content;

    /**
     * @var mixed
     */
    protected $requestThemes;

    /**
     * @var mixed
     */
    protected $requestTypes;

    /**
     * @var mixed
     */
    protected $requestForm;

    /**
     * @var string
     */
    protected $subjectMail = 'form.mail.subject';

    /**
     * @var string
     */
    protected $text = 'form.mail.content';

    /**
     * @param mixed $user
     * @param mixed $requestThemes
     * @param mixed $requestForm
     * @param string $requestContent
     * @param mixed $requestTypes
     */
    public function __construct($user, $requestThemes, $requestForm, string $requestContent, $requestTypes)
    {
        $this->user = $user;
        $this->content = $requestContent;
        $this->requestForm = $requestForm;
        $this->requestThemes = $requestThemes;
        $this->requestTypes = $requestTypes;
    }

    /**
     * @return FormSendEmail
     */
    public function build(): Mailable
    {
        $replacements = [
            'author.fullname' => trim(trim($this->user->firstname).' '.trim($this->user->lastname)),
            'author.email' => $this->user->email,
            'request.themes' => trim($this->requestThemes->title),
            'request.types' => trim($this->requestTypes->title),
            'request.body' => $this->content,
        ];

        return $this->markdown('emails.form-content')->subject(
            Lang::get($this->subjectMail)
        )->with(
            [
                'lines'      => explode(
                    "\n",
                    trim(Lang::get($this->text, $replacements))
                ),
            ]
        )->replyTo($this->user->email);
    }
}
