<?php

namespace Inside\SYAN\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Modal;
use Inside\Reaction\Facades\Reactions;
use Laravel\Lumen\Routing\Controller;

class PopinController extends Controller
{
    public function popin(Request $request): array
    {
        $modal = Modal::where('class', 'welcome')->where('status', true)->first();

        if (empty($modal)) {
            return [
                'popin' => true,
            ];
        }

        /** @var User $user */
        $user = Auth::user();
        $reaction = DB::table('inside_reactions')
            ->where('type', 'modal')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $modal->uuid)->get();

        $count = $reaction->count();

        return [
            'popin' => ! (bool) $count,
            'reaction_date' => $count === 0 ? null : $reaction->pluck('created_at')->first(),
        ];
    }

    public function reaction(Request $request): array
    {
        /** @var User $user */
        $user = Auth::user();

        $modalUuid = $request->get('uuid');
        $modal = Modal::find($modalUuid);

        return Reactions::create([
            'user_uuid' => $user->uuid,
            'reactionable_uuid' => $modalUuid,
            'reactionable_type' => "Inside\Content\Models\Contents\Modal",
            'type' => 'modal',
            'langcode' => $modal->langcode,
        ]);
    }
}
