<?php

namespace Inside\SYAN\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Inside\SYAN\Facades\Horoquartz;
use Inside\SYAN\Services\Horoquartz\HoroquartzService;
use Laravel\Lumen\Routing\Controller;

/**
 * Inside Horoquartz Controller.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class HoroquartzController extends Controller
{
    private HoroquartzService $horoquartz;

    public function __construct()
    {
        $this->horoquartz = new HoroquartzService();
    }

    public function getBalance(): JsonResponse
    {
        return new JsonResponse([
            'balance' => $this->horoquartz->getVacationBalance(),
            'cumulated' => $this->horoquartz->getCumulatedDayBefore(),
        ], 200);
    }

    public function badging(): JsonResponse
    {
        $this->horoquartz->badging();

        return $this->getLastBadging();
    }

    public function getLastBadging(): JsonResponse
    {
        return new JsonResponse($this->horoquartz->getDailyBadging(), 200);
    }
}
