<?php

namespace Inside\SYAN\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Queue;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\RequestForms;
use Inside\Content\Models\Contents\RequestThemes;
use Inside\Content\Models\Contents\RequestTypes;
use Inside\Content\Models\Contents\Users;
use Inside\SYAN\Http\Requests\SendMailRequest;
use Inside\SYAN\Jobs\FormSend;
use Laravel\Lumen\Routing\Controller;

/**
 * Class FormCustomController
 */
class FormCustomController extends Controller
{
    /**
     * @param SendMailRequest $request
     *
     * @return JsonResponse
     */
    public function sendMail(SendMailRequest $request): JsonResponse
    {
        /** @var User $currentUser */
        $currentUser = Auth::user();
        $user = Users::find($currentUser->uuid);
        $requestTypes = RequestTypes::find($request->get('request_type'));
        $requestForm = RequestForms::find($request->get('request_form'));
        $requestThemes = RequestThemes::find($request->get('theme'));
        $requestContent = $request->get('request_content');

        Queue::push(new FormSend($user, $requestThemes, $requestForm, $requestContent, $requestTypes));

        return response()->json(
            [
                'success' => true,
            ]
        );
    }
}
