<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Menu\Models\HeaderMenuLink;

final class UpdateCollectivitiesCustomPage extends Migration
{
    public function up(): void
    {
        if (! Schema::hasModel('custom')) {
            return;
        }

        Artisan::call('models:rebuild');

        $custom = [
            'title' => 'Annuaire des collectivités',
            'introduction' => 'Retrouvez les coordonnées des collectivités du Syane',
            'redirection_page' => 'CollectivitiesDirectoryPage',
            'custom_slug' => 'collectivities',
        ];

        $existing = Custom::query()
            ->where('redirection_page', 'ServicesDirectoryPage')
            ->where('custom_slug', 'services')
            ->first();

        if ($existing instanceof Custom) {
            $custom['uuid'] = $existing->uuid;
        }

        $uuid = (new BridgeContent())->contentInsert('custom', $custom, ! isset($custom['uuid']), true);

        if ($uuid === null) {
            return;
        }

        HeaderMenuLink::where('link', "custom|$uuid")->each(fn (HeaderMenuLink $menuLink) => $menuLink->update(['title' => 'Collectivités', 'page' => 'CollectivitiesDirectoryPage']));
    }
}
