<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateCollectivitiesContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        if (Schema::hasModel('public_services')) {
            $this->getBridge()?->contentTypeDelete('public_services');
        }

        if (Schema::hasModel('intercommunities')) {
            $this->getBridge()?->contentTypeDelete('intercommunities');
        }

        $this->migrateContent('collectivities_types');
        $this->migrateContent('collectivities');

        $this->getBridge()?->contentTypeUpdate('communes', ['title' => ['fr' => 'Collectivité (commune)']]);
        $this->finishUp();
    }
}
