<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateUsersMandatField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'mandat',
            options: [
                'name' => 'mandat',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Mandat',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
        );
        $this->finishUp();
    }
}
