<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RefactoFieldFunction extends Migration
{
    use Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $this->bootUp(__FILE__);
        $this->migrateContent('function_agent');
        $this->migrateContent('function_delegate');
        $this->migrateContent('users');
        $this->finishUp();

        $bridge->contentTypeDeleteField('node', 'public_services', 'intercommunity');
        $bridge->contentTypeCreateOrUpdateField('public_services', 'intercommunities', [
            'name' => 'intercommunities',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Intercommunalité',
            ],
            'description' => [
                'fr' => 'Choix de la catégorie dans laquelle cet outil doit remonter',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['intercommunities'],
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
