<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldWeight extends Migration
{
    use Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('content_block', 'weight', [
            'name' => 'weight',
            'type' => BridgeContentType::INTEGER_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'title' => [
                'fr' => 'Poids',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
