<?php

use Inside\SYAN\Facades\ImportCsv;

return [
    'files' => [
        'syan' => [
            'path' => env('XLSX_USERS_PATH', __DIR__.'/../../../../imports/import.xlsx'),
            'fields' => [
                'name' => 'mail',
                'mail' => 'mail',
                'firstname' => fn ($record) => ucwords($record['prenom']),
                'lastname' => fn ($record) => ucwords($record['nom']),
                'communes' => fn ($record) => ImportCsv::getEntityReference($record, 'communes', 'commune'),
                'districts' => fn ($record) => ImportCsv::getEntityReference($record, 'districts', 'arrondissement'),
                'mandat' => fn ($record) => trim($record['mandat']),
                'function_delegate' => fn ($record) => ImportCsv::getEntityReference($record, 'function_delegate', 'fonction syane'),
                'committee' => fn ($record) => ucwords($record['comite']),
                'offices' => fn ($record) => ImportCsv::getEntityReference($record, 'offices', 'bureau'),
                'executive' => fn ($record) => ucwords($record['executif']),
                'commissions' => fn ($record) => ImportCsv::getEntityReference($record, 'commissions', 'commission', '/'),
                'mobile_phone' => fn ($record) => ucwords($record['tel']),
                'colleges' => fn ($record) => ImportCsv::getEntityReference($record, 'colleges', 'college'),
                'send_mail' => fn () => true,
                'status' => fn () => true,
                'langcode' => fn () => 'fr',
            ],
            'original_fields' => [
                'mail' => 'mail',
                'prenom' => 'firstname',
                'nom' => 'lastname',
                'commune' => 'city',
                'arrondissement' => 'word',
                'mandat' => 'word',
                'fonction syane' => 'word',
                'comite' => 'word',
                'bureau' => 'word',
                'executif' => 'word',
                'commission' => 'word',
                'tel' => 'word',
                'college' => 'word',
            ],
        ],
    ],
];
