<?php

return [
    'types' => [
        'news' => [
            'category' => 'news_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'documents' => [
            'category' => 'folders',
            'comments' => false,
            'likes'    => false,
        ],
        'events' => [
            'category' => 'events_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'tools' => [
            'category' => 'tools_categories',
            'comments' => false,
            'likes'    => false,
        ],
        'delegates_space' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'hr_space' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'request_forms' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'organizations' => [
            'category' => 'categories',
            'comments' => false,
            'likes'    => false,
        ],
        'job_offers' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'public_services' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'movements' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
    ],
    'export' => [
        'contents' => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL').'/edit/'.class_to_type($model).'/'.$model->uuid;
                },
            ],
        ],
        'users'    => [
            'headers' => [
                'email'    => 'Mail address',
                'full_name' => 'Full name',
            ],
        ],
        'authentication' => [
            'headers' => [
            ],
        ],
    ],
];
