<?php

use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Users;
use Inside\Support\Stringable;

return [
    'postfilter' => fn (Collection $users) => $users->reject(fn (mixed $user) => empty($user->companyName)),
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'mobile_phone' => 'mobilePhone',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'matricule' => fn (mixed $user) => $user->companyName,
        'internal_number' => fn (mixed $user) => $user->onPremisesExtensionAttributes->extensionAttribute1,
        'phone' => fn (mixed $user) => Arr::first($user->businessPhones),
        'function_agent' => fn (mixed $user) => reference('function_agent')->from($user->jobTitle)->get(),
        'functions' => fn (mixed $user) => reference('functions')->from($user->jobTitle)->get(),
        'directions' => fn (mixed $user) => reference('directions')->from($user->department)->get(),
        'manager' => fn (mixed $user) => reference('users')->from($user->manager)->identifiedBy('email')->withoutCreation()->get(),
        'langcode' => fn () => 'fr',
        'status' => fn () => true,
        'is_agent' => fn () => true,
        'upn' => 'userPrincipalName',
        'image' => function (mixed $user) {
            $fileName = explode('@', $user->mail);
            $fileName = $fileName[0].'.jpg';
            $imgPath = 'profile/'.$fileName;
            $insideUser = Users::query()->where('email', $user->mail)->first();

            if (! Storage::exists($imgPath)) {
                return $insideUser ? $insideUser->image : null;
            }

            if ($insideUser && $insideUser->image) {
                return $insideUser->image;
            }

            $chunkId = Str::random(32);
            $finalFolderPath = "chunks/$chunkId";
            $finalPath = "$finalFolderPath/$fileName";

            Storage::makeDirectory($finalFolderPath);
            Storage::copy($imgPath, $finalPath);

            return $finalPath;
        },
    ],
    'custom_attributes' => [
        'manager' => 'mail',
    ],
];
