import { getContentImage } from '@inside-library/helpers/Image'

export default {
  'inside-commons': {
    banner: {
      introductionKey: 'custom_introduction',
      html: true
    }
  },
  globals: {
    notificationRedirectionsContentTypes: ['news', 'events'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      }),
      events: async ({ data }) => ({
        name: 'EventPage',
        params: {
          slug: data.slug[0]
        }
      })
    }
  },
  'inside-events': {
    rootRoute: {
      fr: 'agenda'
    }
  },
  'inside-ged': {
    useBookmarks: true,
    rootRoute: {
      fr: 'ressources'
    }
  },
  'inside-news': {
    showBookmarks: false
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/directory/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'small')
        }),
        selectionConfig: {
          fields: [
            'uuid_host',
            'firstname',
            'lastname',
            'mobile',
            'jobs',
            'image'
          ],
          filters: {
            'status:eq': 1,
            sort: 'lastname:asc',
            'is_maintenance:eq': 0
          }
        },
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'mobile',
          'jobs',
          'image'
        ]
      }
    }
  }
}
