import { http } from '@inside-library/helpers/Http'

const fetchJobSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/jobs_spaces', {
      filters: { slug: $route.params.slug },
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'description',
        'image',
        'admin',
        'new_comers',
        'presentation_app_offers',
        'image_offers',
        {
          key_contacts: [
            'uuid',
            'firstname',
            'lastname',
            'image',
            'jobs',
            'mobile'
          ]
        },
        {
          tools: [
            'title',
            'uuid',
            'has_section',
            'tools_link',
            'admin',
            'image',
            'class',
            'content_type',
            {
              tools_categories: [
                'uuid',
                { tools_categories_listings: ['uuid', 'slug'] }
              ]
            }
          ]
        },
        { news_categories: ['uuid', 'title'] },
        { events_categories: ['uuid', 'title'] },
        {
          folders: {
            fields: [
              'uuid',
              'title',
              'color',
              {
                documents: {
                  fields: [
                    'uuid',
                    'title',
                    'content',
                    { folders: ['uuid', 'title'] },
                    'file',
                    'published_at',
                    'updated_at',
                    'content_type'
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    'published_at:lte': 'now()',
                    sort: 'updated_at:desc',
                    limit: 3
                  }
                }
              }
            ]
          }
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchJobPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/jobs_pages', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'image',
        {
          jobs_grouping_pages: {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'status:eq': 1 }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    const uuidGroupingSpace = data[0].jobs_grouping_pages.uuid

    const { data: jobSPace } = await http.get('content/jobs_grouping_pages', {
      fields: [
        {
          job_spaces: {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'status:eq': 1 }
          }
        }
      ],
      filters: { 'uuid:eq': uuidGroupingSpace }
    })

    return { ...data[0], job_spaces: jobSPace[0].job_spaces }
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchJobSpace, fetchJobPage }
