import { http } from '@inside-library/helpers/Http'

const fetchLifeServices = async () => {
  try {
    const { data } = await http.get('content/life_services', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'updated_at',
        'content_type',
        'content',
        'link_title'
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()',
        limit: 1
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchLifeServices }
