import JobSpace from '../pages/job/JobSpace'
import JobPage from '../pages/job/JobPage'
import { fetchJobSpace, fetchJobPage } from '../components/job/fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      filtersInput: 'selectbox',
      extraFields: ['introduction'],
      componentAttributes: () => ({
        chapoKey: 'introduction'
      })
    }
  },
  {
    name: 'NewsPage',
    meta: {
      disabled: false
    },
    props: {
      filtersInput: 'selectbox',
      relatedOptions: {
        extraFields: ['introduction'],
        componentAttributes: () => ({
          chapoKey: 'introduction'
        })
      }
    }
  },
  {
    name: 'EventsCalendarPage',
    component: () => import('../pages/events/EventsListingPage'),
    meta: {
      disabled: false
    }
  },
  {
    name: 'EventPage',
    component: () => import('../pages/events/EventPage'),
    meta: {
      disabled: false,
      content: 'events'
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      extraFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: { cardOverlayEnabled: false }
  },
  {
    path: '/annuaires/collaborateurs-ssti-33',
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    path: '/annuaires/centres',
    name: 'CentersListingPage',
    component: () => import('../pages/directory/CentersListingPage')
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    path: '/projet-de-service',
    name: 'CarrefourPage',
    component: () => import('../pages/CarrefourPage')
  },
  {
    path: '/projet-de-service/:slug',
    name: 'InfoContentPage',
    component: () => import('../pages/info-content/InfoContentPage')
  },
  {
    path: '/espace/:slug',
    name: 'JobSpace',
    component: withFetch(JobSpace, { size: 'xxl', watch: true })(fetchJobSpace)
  },
  {
    path: '/page-metier/:slug',
    name: 'JobPage',
    component: withFetch(JobPage, { size: 'xxl', watch: true })(fetchJobPage)
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
