import { http } from '@inside-library/helpers/Http'
import get from 'lodash/get'

export default {
  pages: {
    add: ({ data }) => {
      return {
        name: 'Pages',
        params: { slug: data.slug[0] }
      }
    }
  },
  centers: {
    add: () => ({
      name: 'CentersListingPage',
      params: { slug: 'centres' }
    }),
    delete: () => ({ name: 'CentersListingPage', params: { slug: 'centres' } }),
    globalSearch: ({ vm, data }) => ({
      action: vm.triggerModal(
        'center',
        'fetch',
        { item: data, content: data.content_type },
        { layout: 'right', transition: 'fadeInLeft' }
      )
    })
  },
  infoContents: {
    add: () => ({ name: 'CarrefourPage' }),
    delete: () => ({ name: 'CarrefourPage' }),
    globalSearch: ({ data, vm }) => ({
      action: async () => {
        try {
          const { data: infoData } = await http.get('content/info_contents', {
            fields: ['uuid', 'link', 'is_modals', 'content_type', 'slug'],
            filters: { 'uuid:eq': data.uuid }
          })

          if (infoData[0].is_modals) {
            vm.triggerModal(
              'simple',
              'fetch',
              { item: infoData, content: infoData.content_type },
              { layout: 'right', transition: 'fadeInLeft' }
            )
          } else if (infoData[0].link) {
            window.open(infoData[0].link, '_blank')
          } else {
            vm.$router.push({
              name: 'InfoContentPage',
              params: { slug: infoData[0].slug[0] }
            })
          }
        } catch (err) {
          throw new Error(err)
        }
      }
    })
  },
  jobsSpaces: {
    add: ({ data }) => ({
      name: 'JobSpace',
      params: { slug: data.slug[0] }
    })
  },
  jobsGroupingPages: {
    fields: ['uuid', { job_spaces: ['slug'] }],
    add: ({ data }) => {
      return {
        name: 'JobSpace',
        params: {
          slug: data.job_spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/jobs_grouping_pages', {
          fields: [
            {
              job_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        const slug =
          get(data, [0, 'job_spaces', 'slug', 0]) ||
          get(data, [0, 'job_spaces', 'data', 0, 'slug', 0])

        return {
          name: 'JobSpace',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  },
  lifeServices: {
    add: () => ({ path: '/' })
  },
  referent: {
    add: () => ({ path: '/' })
  },
  jobsPages: {
    add: ({ data }) => ({
      name: 'JobPage',
      params: { slug: data.slug[0] }
    }),
    delete: async ({ uuid }) => {
      try {
        let { data } = await http.get('content/jobs_pages', {
          fields: [
            {
              jobs_grouping_pages: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })
        let uuidGroupingSpace = data[0].jobs_grouping_pages.uuid

        data = await http.get('content/jobs_grouping_pages', {
          fields: [
            {
              job_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidGroupingSpace }
        })

        const slug =
          get(data, ['data', 0, 'job_spaces', 'slug', 0]) ||
          get(data, ['data', 0, 'job_spaces', 'data', 0, 'slug', 0])

        return {
          name: 'JobSpace',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  }
}
