import { isExternal } from 'inside-collection/helpers'

export default {
  methods: {
    $_handleClick(item) {
      if (item.link) {
        this.$_openLink(item.link)
      } else if (item.is_modals) {
        this.$_openModal(item.uuid)
      } else {
        this.$router.push({
          name: 'InfoContentPage',
          params: { slug: item.slug[0] }
        })
      }
    },
    $_openLink(link) {
      if (isExternal(link)) {
        window.open(link, '_blank')
      } else {
        this.$router.push({ path: `/${link}` })
      }
    },
    $_openModal(uuid) {
      this.triggerModal(
        'simple',
        'fetch',
        { item: { uuid: uuid }, content: 'info_contents' },
        {
          layout: 'right',
          size: 'm',
          transition: 'fadeInLeft'
        }
      )
    }
  }
}
