<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Custom;

class UpdateTypeFieldIntroduction extends Migration
{
    public function up(): void
    {
        $bridgeType = new BridgeContentType();

        $bridgeType->contentTypeCreateOrUpdateField('custom', 'custom_introduction', [
            'name' => 'custom_introduction',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'default' => false,
            'title' => [
                'fr' => 'Introduction',
            ],
            'settings' => [],
            'widget' => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
            ],
        ], 3);

        $bridge = new BridgeContent();

        foreach (Custom::get() as $custom) {
            $bridge->contentUpdate('custom', [
                'uuid' => $custom->uuid,
                'author' => $custom->author,
                'custom_introduction' => $custom->introduction
            ]);
        }

        $bridgeType->contentTypeDeleteField('node', 'custom', 'introduction');
    }

    public function down(): void
    {
    }
}
