<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class UpdateWayLikeAndCommentNotificationsSent extends Migration
{
    public function up(): void
    {
        $notificationTypeComments = NotificationType::query()
            ->where('model', 'Inside\Content\Models\Contents\Comments')
            ->where('via', 'email')
            ->where('type', 'global')->get();

        if ($notificationTypeComments->isNotEmpty()) {
            /** @var NotificationType $notificationTypeComment */
            foreach ($notificationTypeComments as $notificationTypeComment) {
                $notificationTypeComment->via = 'web';
                $notificationTypeComment->save();
            }
        }

        $notificationTypeReaction = NotificationType::query()
            ->where('event', 'Inside\Reaction\Events\ReactionSubscribedEvent')
            ->where('via', 'email')
            ->where('action', 'like')->first();
        if ($notificationTypeReaction instanceof NotificationType) {
            $notificationTypeReaction->via = 'web';
            $notificationTypeReaction->save();
        }
    }

    public function down(): void
    {
    }
}
