<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddTradTextCommentNotifications extends Migration
{
    public function up(): void
    {
        $notificationTypeComments = NotificationType::query()
            ->where('model', 'Inside\Content\Models\Contents\Comments')
            ->where('via', 'web')
            ->where('action', 'contentCommented')
            ->where('type', 'global')->get();

        if ($notificationTypeComments->isNotEmpty()) {
            /** @var NotificationType $notificationTypeComment */
            foreach ($notificationTypeComments as $notificationTypeComment) {
                $notificationTypeComment->data = [
                    'title' => 'notifications.create.comment.content.title',
                    'description' => 'notifications.create.comment.content.description',
                    'text' => 'notifications.create.comment.content.<content_type>.text',
                    'fields' => [
                        'notification-data.from' => ['firstname', 'lastname'],
                        'title',
                        'content_type',
                    ],
                ];
                $notificationTypeComment->save();
            }
        }

        $notificationTypeCommentCommenteds = NotificationType::query()
            ->where('model', 'Inside\Content\Models\Contents\Comments')
            ->where('via', 'web')
            ->where('action', 'commentCommented')
            ->where('type', 'global')->get();

        if ($notificationTypeCommentCommenteds->isNotEmpty()) {
            /** @var NotificationType $notificationTypeCommentCommented */
            foreach ($notificationTypeCommentCommenteds as $notificationTypeCommentCommented) {
                $notificationTypeCommentCommented->data = [
                    'title'       => 'notifications.create.comment.comment.title',
                    'description' => 'notifications.create.comment.comment.description',
                    'icon'        => 'comment',
                    'text'        => 'notifications.create.comment.comment.<content_type>.text',
                    'fields' => [
                        'notification-data.from' => ['firstname', 'lastname'],
                        'title',
                        'content_type',
                    ],
                ];
                $notificationTypeCommentCommented->save();
            }
        }
    }

    public function down(): void
    {
    }
}
