<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldSlug extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('info_contents', 'slug', [
            'name' => 'slug',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'slug'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 8,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
