<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixFieldContent extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $field = [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'accordion',
                    'button',
                    'call_to_action',
                    'fetched_contents',
                    'file',
                    'files',
                    'html',
                    'image',
                    'map',
                    'separator',
                    'slide',
                    'slider',
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'tweet',
                    'user_cards',
                    'video',
                ],
                'cardinality' => -1,
            ],
        ];

        $bridge->contentTypeDeleteField('node', 'info_contents', 'crossroads_page');
        $bridge->contentTypeCreateOrUpdateField('news', 'content', $field);
        $bridge->contentTypeCreateOrUpdateField('centers', 'content', $field);
        $bridge->contentTypeCreateOrUpdateField('events', 'content', $field);
        $bridge->contentTypeCreateOrUpdateField('info_contents', 'content', $field);
        $bridge->contentTypeCreateOrUpdateField('documents', 'content', $field);
        $bridge->contentTypeCreateOrUpdateField('tools', 'content', $field);
        $bridge->contentTypeCreateOrUpdateField('jobs_pages', 'content', $field);
        $bridge->contentTypeCreateOrUpdateField('life_services', 'content', $field);
        $bridge->contentTypeCreateOrUpdateField('pages', 'content', $field);
        $bridge->contentTypeCreateOrUpdateField('jobs_grouping_pages', 'icon', [
                'name' => 'icon',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 8,
                'title' => [
                    'fr' => 'Icône'
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                    'weight' => 8,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('jobs_spaces', 'image_offers', [
            'name' => 'image_offers',
            'type' => BridgeContentType::IMAGE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => true,
            'weight' => 9,
            'title' => [
                'fr' => 'Image offres de candidature',
            ],
            'description' => [
                'fr' => 'Correspond à l\'image d\'illustration du bloc reservé aux offres de candidatures'
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 9,
            ],
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('info_contents', 'page_custom', [
            'name' => 'page_custom',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Page à remonter',
            ],
            'description' => [
                'fr' => 'Selectionnez la page personnalisée sur laquelle le contenu remontera',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['custom'],
                'cardinality' => 1,
            ],
        ]);


        $this->bootUp(__FILE__);
        $this->migrateContent('users');
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
