<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'name' => 'users',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'title' => [
            'fr' => 'Utilisateur',
        ],
    ],
    'fields' => [
        [
            'name' => 'services',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Service',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'settings' => [
                'target_type' => 'services',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'post_number',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Numéro de poste',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'centers_2',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Centre 2',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'phone_centers_2',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Téléphone centre 2',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'phone_centers',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Téléphone centre 1',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]
    ],
];
