<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'life_services',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'title' => [
            'fr' => 'Vie du service',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'link_title',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Titre du lien',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'accordion',
                    'button',
                    'call_to_action',
                    'document_cards',
                    'fetched_contents',
                    'file',
                    'files',
                    'html',
                    'image',
                    'map',
                    'separator',
                    'slide',
                    'slider',
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'tweet',
                    'updated_document_cards',
                    'user_cards',
                    'video',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
