<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'name' => 'info_contents',
        'title' => [
            'fr' => 'Contenu info',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'type' => BridgeContentType::IMAGE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Bannière',
            ],
            'description' => [
                'fr' => 'Cette image remontera dans la page mère de l\'espace documentaire'
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => $weight++,
            ],
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'accordion',
                    'button',
                    'call_to_action',
                    'document_cards',
                    'fetched_contents',
                    'file',
                    'files',
                    'html',
                    'image',
                    'map',
                    'separator',
                    'slide',
                    'slider',
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'tweet',
                    'updated_document_cards',
                    'user_cards',
                    'video',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'link',
            'type' => BridgeContentType::LINK_FIELD,
            'searchable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Lien',
            ],
            'description' => [
                'fr' => 'Intégrez une URL "https://". Si ce champ est rempli, l\'utilisateur sera directement renvoyé vers ce lien au clic que le bloc'
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'is_modals',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'default' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Ouvrir le contenu dans une "modale"',
            ],
            'description' => [
                'fr' => 'La modale permet d\'afficher les contenus courts en ouvrant le contenu directement sur la page
                        (même fonctionnement que sur l\'annuaire par exemple).',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'type' => BridgeContentType::INTEGER_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Ordre d\'affichage',
            ],
            'description' => [
                'fr' => 'Intégrez une valeur chiffrée, la plus petite remontant en 1re position'
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'crossroads_page',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Page carrefour concernée',
            ],
            'description' => [
                'fr' => 'Selectionnez le page carrefour sur laquelle le contenu remontera',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['crossroads_page'],
                'cardinality' => 1,
            ],
        ],
    ]
];
