<?php

namespace Inside\SSTI\Providers;

use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * SSTI Service provider.
 *
 * @category Class
 * @package  Inside\SSTI\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
